/**@@@+++@@@@******************************************************************
**
** Microsoft Windows Media
** Copyright (C) Microsoft Corporation. All rights reserved.
**
***@@@---@@@@******************************************************************
*/

/*#include <stdio.h>
#include <stdlib.h>
#include <string.h>*/
#include "DX_VOS_Utils.h"
#include "drmcommon.h"
#include "drmutilities.h"
#include "drmcontextsizes.h"
#include "drmexpreval.h"
#include "tOEMIMP.h" 

#include "drmcrt.h"
#include "drmresults.h"
#include "drmtypes.h"
#include "drmliceval.h"
#include "drmheaderparser.h"
#include "drmlicenseparser.h"
#include "drmmanager.h"
#include "drmpkcrypto.h"
#include "drmlicacq.h"
#include "drmcipher.h"
#include "drmblackbox.h"
#include "drmviewprops.h"

#if DRM_SUPPORT_APP_REVOCATION
	#include <drmrevocation.h>
#endif

#include "tclib.h"
#include "tstutils.h"
#include "ExprEval.h"
#include "Licenses.h"
#include "teststubcerts.h"

#define ASSIGN_WSTR_TO_DRMSTRING(x,y) {(x).pwszString=(y);(x).cchString=DRM_wcslen(y);}

static const char _devcerttemplate[] = "devcerttemplate.dat";
static DRM_WCHAR devcerttemplate[sizeof(_devcerttemplate) + 1];

static const char _priv[] = "priv.dat";
static DRM_WCHAR priv[sizeof(_priv) + 1];

static const char _wszHeader[] = "<WRMHEADER version=\"2.0.0.0\"><DATA><LAINFO>http://v2srv/WM/getv2lic.asp</LAINFO><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><CHECKSUM>oA7EpBNu3g==</CHECKSUM><CID>3</CID><NAME>V2_5sec.wma</NAME></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>QrUgBBheJVzAOOw2kbo*1sqJkwft4oXKNBPv56PpUhho5fS6XK6sTg==</VALUE></SIGNATURE></WRMHEADER>";
static DRM_WCHAR wszHeader[sizeof(_wszHeader) + 1];

static const char _wszDefaultHeader[] = "<WRMHEADER version=\"2.0.0.0\"><DATA><LAINFO>http://kganesan1/wm/getv2lic.asp?WMPFriendly=1</LAINFO><KID>NtU91UHN0xGLYgDAT3nsdQ==</KID><CHECKSUM>tYxiHBckHg==</CHECKSUM><CID>1</CID><SECURITYVERSION>2.0.0.0</SECURITYVERSION><OWNER><NAME>Elvis</NAME><ID>123</ID></OWNER></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>vxdNIqchmBJsa00ibiYqWB59UDMeg0N6ULlKdDpGjVKVbSdegQwwTg==</VALUE></SIGNATURE></WRMHEADER>";
static DRM_WCHAR wszDefaultHeader[sizeof(_wszDefaultHeader)];

static const char _wszOldHeader[] = "<WRMHEADER version=\"0.0.0.1\"><DATA><LAINFO>http://kganesan1/wm/getv2lic.asp?WMPFriendly=1</LAINFO><KID>NtU91UHN0xGLYgDAT3nsdQ==</KID><CHECKSUM>tYxiHBckHg==</CHECKSUM><CID>1</CID><SECURITYVERSION>2.0.0.0</SECURITYVERSION><OWNER><NAME>Elvis</NAME><ID>123</ID></OWNER></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>vxdNIqchmBJsa00ibiYqWB59UDMeg0N6ULlKdDpGjVKVbSdegQwwTg==</VALUE></SIGNATURE></WRMHEADER>";
static DRM_WCHAR wszOldHeader[sizeof(_wszOldHeader) + 1];

static const char _wszBogusHeader[] = "<BOGUSHEAD bogusattr=\"0.0.0.1\"><DATA><LAINFO>http://kganesan1/wm/getv2lic.asp?WMPFriendly=1</LAINFO><KID>NtU91UHN0xGLYgDAT3nsdQ==</KID><CHECKSUM>tYxiHBckHg==</CHECKSUM><CID>1</CID><SECURITYVERSION>2.0.0.0</SECURITYVERSION><OWNER><NAME>Elvis</NAME><ID>123</ID></OWNER></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>vxdNIqchmBJsa00ibiYqWB59UDMeg0N6ULlKdDpGjVKVbSdegQwwTg==</VALUE></SIGNATURE></BOGUSHEAD>";
static DRM_WCHAR wszBogusHeader[sizeof(_wszBogusHeader) + 1];


static const char _g_wcszInvalidBB_VERSION_STRING[] = "1.0.0.0";
static DRM_WCHAR g_wcszInvalidBB_VERSION_STRING[sizeof(_g_wcszInvalidBB_VERSION_STRING) + 1];
static const char _g_wcszInvalidDRM_VERSION_STRING[] = "1.0.0.1";
static DRM_WCHAR g_wcszInvalidDRM_VERSION_STRING[sizeof(_g_wcszInvalidDRM_VERSION_STRING) + 1];

static const char _InvalidrgbLID[] = "{11117A28-3AAA-7777-AF13-F77A5258A9F1}";
static DRM_WCHAR InvalidrgbLID[sizeof(_InvalidrgbLID) + 1];
static const char _InvalidrgbKID[] = "1111Sn1czUaZpE4OPSbZbg==";
static DRM_WCHAR InvalidrgbKID[sizeof(_InvalidrgbKID)+1];

static const char _wszLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META><NAME>License for Titatic</NAME><DESCRIPTION>License to play on pc and burn CD</DESCRIPTION><TERMS>This license is not transferable</TERMS><TRANSACTIONID>12344</TRANSACTIONID><LICENSORNAME>Reciprocal</LICENSORNAME><LICENSORSITE>www.reciprocal.com</LICENSORSITE></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;pmlicense.expirydate=#20040101Z#;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>\0";
static DRM_WCHAR wszLicense[sizeof(_wszLicense) +1];

static const char _wszOldLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>";
static DRM_WCHAR wszOldLicense[sizeof(_wszOldLicense) + 1];

static const char _wszInvalidLicense[] = "<LICENSE version=\"1.0.1.0\"><LICENSORINFO><DATA><LID>{11117A28-3FEE-7777-AF13-F77A5258A9F1}</LID><KID>1111Sn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>";
static DRM_WCHAR wszInvalidLicense[sizeof(_wszInvalidLicense) + 1];

static const char _wszNOStoreRightLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>\0";
static DRM_WCHAR wszNOStoreRightLicense[sizeof(_wszNOStoreRightLicense) + 1];

static const char _wszNOSelectRightLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>\0";
static DRM_WCHAR wszNOSelectRightLicense[sizeof(_wszNOSelectRightLicense)+ 1 ];

static const char _wszNODeleteRightLicense[] = "<LICENSE version=\"2.0.0.0\"><LICENSORINFO><DATA><LID>{45227A28-3FEE-4EB5-AF13-F77A5258A9F1}</LID><KID>lbPgSn1czUaZpE4OPSbZbg==</KID><ISSUEDATE>#20030314 18:52:44Z#</ISSUEDATE><PRIORITY>100</PRIORITY><RevocationList>OqehmL4rlyKSsPS750TGRPpn3Qhh6S7RlJZSVwdCmUB2T9kAqW7dfgIAAAAwAAAAAQAAAAAAAAAoAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA==</RevocationList><CONTENTPUBKEY>7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMg==</CONTENTPUBKEY><META></META><ONACTION type=\"Restore\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"Backup\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONACTION type=\"CREATE_PM_LICENSE\"><CONDITION><![CDATA[pmlicense.rights = 19;pmlicense.appseclevel = 150;1]]></CONDITION></ONACTION><ONACTION type=\"Play\"><CONDITION><![CDATA[1]]></CONDITION></ONACTION><ONSELECT><CONDITION><![CDATA[(!exists(secstate.deleted) && (app.minseclevel >= 500?1:(secstate.drmreason=3;0)))]]></CONDITION></ONSELECT><ONSTORE><ACTION><![CDATA[!exists(secstate.MinAppSecLevel)?secstate.MinAppSecLevel=500:0]]></ACTION></ONSTORE><ENABLINGBITS><ALGORITHM type=\"MSDRM\"></ALGORITHM><PUBKEY type=\"machine\">6dfMynp*3VWeQU8*dCdMthN0vzgbabR3XggMgNZSPaMiACQM1GWBVQ==</PUBKEY><VALUE>0NmydbHzSs11syH5qbcnmNijtmMAY0uGJE7NiP2HxoabbT1nLihKMoe06KGW6n*jFqWBEhJR8cs26nBOqp53mBZ7BRXwdTpB1vjsomF4Rxc=</VALUE><SIGNATURE>v2n8fwjG77ZEwZC1nZB!PaibbGLrxGvO7WQekd8X0fniRI7WYc42Gw==</SIGNATURE></ENABLINGBITS></DATA><SIGNATURE><HASHALGORITHM type=\"SHA\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN><SIGNATURE><HASHALGORITHM type=\"SHA2\"></HASHALGORITHM><SIGNALGORITHM type=\"MSDRM\"></SIGNALGORITHM><VALUE>4TFUkNdkfX!zaTAug0*drckKrS98ysCeeycyL6lnEKArQiNbRjKIgQ==</VALUE></SIGNATURE><CERTIFICATECHAIN type=\"MSDRM\"><CERTIFICATE>AAEAADgAAADx8JZr89PDErAy8nc4Dk*ndLPDbqG0oXwUd3YrbpUiZx5!xDYvTuoGkLwhX2yhPd*XemSyR4vt980PUUPh0mOVjfcPK0zVi9lcr5zN8Jy7LhQDCA0AAAAIAAAAAQAAAAE=</CERTIFICATE><CERTIFICATE>AAEAADgAAADu8MlLHuLr6TlzZkXkL3*jW7kJKYNtuoDnkMItge!KwrcRjRhd0NAV7BZ*gTLq*LKyT3GcIWH8d5JkWiklMf7Aod!lhBgJpcTRu!chtojzMhQDBxMAABINAAAAAgAATGk=</CERTIFICATE></CERTIFICATECHAIN></LICENSORINFO></LICENSE>\0";
static DRM_WCHAR wszNODeleteRightLicense[sizeof(_wszNODeleteRightLicense) + 1];


static DRM_HDS_CONTEXT *g_pHdsContext = NULL;

/*
argv[0]: iOptions: the field of the LicEvalContext to be overwritten
argv[1]: instruction for this field: valid, wrong, invalid, NULL

iOptions:
	0.  all valid fields
	1.  pContextBBX;
    2.  ExprEvalContext;
    3.  dstrContentHeader;
    4.  dstrContentLicense;
    5.  dstrBBVer;
    6.  dstrDRMVer;
    7.  pcontextSSTLicense;
    8.  pcontextSSTGlobal;
    9.  pcontextSSTRevocation;
    12. rgbLID;
    13. rgbKID;
    14. fGlobalSecStoreWritable;
    15. dwFlags;        //Default as this LICEVAL_OPEN_CHECK_SETTINGS 
    16. pbBuffer;       //User gives a point to work in.  This is actually going to be used for revocation from the secure store 
    17. cbBuffer;       //Size of the user supplied pointer     
    18. fReserved;      // Must be initialized to 0 
	19. SecureStoreGlobalPassword // Talk to blackbox to get the global secure store password
*/

DRM_RESULT XPV_TestLicEvalContextSetting(long argc, char **argv)
{
	int iOptions = 0;
	int idx;
	DRM_BYTE rgbBuffer[MAX_DEVICE_CERT_SIZE];    
    DRM_CONST_STRING dstrDevCert;    
	DRM_CONST_STRING wszValue;
	DRM_BYTE szSecStorePassword[SHA_DIGEST_LEN];
	DRM_LID lid;

	Log("Trace", "\t\tFrom TestLicEvalContextSetting, argc = %d", argc);
    
    DSTR_FROM_PB( &dstrDevCert, rgbBuffer, SIZEOF(rgbBuffer) );

	for(idx=0; idx<argc; idx++){
		Log("Trace", "\t\tFrom TestLicEvalContextSetting: argv[%d]=%s", idx, argv[idx]);
	}
	
	/* at least 2 arguments, 1st arg for options, 2nd arg for the instruction pass in. */
	ChkArg(argc > 1);

	iOptions = OEM_atoi(argv[0]);
	
	DX_VOS_MemSet( &(Context), 0, sizeof( DRM_LICEVAL_CONTEXT ) );

	if (iOptions != 15) /* dwFlags: Default as this LICEVAL_OPEN_CHECK_SETTINGS */
		Context.dwFlags = LICEVAL_OPEN_CHECK_SETTINGS;    
	else if (!argv[1])
		Context.dwFlags =  0;
	else if(!DX_VOS_StrCmp(argv[1],"valid"))
		Context.dwFlags = LICEVAL_STORE_CHECK_SETTINGS;
	else if (!DX_VOS_StrCmp(argv[1],"invalid"))               
		Context.dwFlags = LICEVAL_OPEN_CHECK_SETTINGS | 8;

	if(iOptions!=1)
		Context.pcontextBBX = &oBBContext; 
	else            /* NULL CryptoContext */
		Context.pcontextBBX = NULL;

	/*blackbox initialized */
    ChkDR( DRM_DDC_GetDeviceCertificate( (DRM_STRING*)&dstrDevCert, 0, &oBBContext.CryptoContext ) );
    ChkDR( DRM_DCP_LoadPropertiesCache( &dstrDevCert, &oBBContext.cachedCertValues, &oBBContext.CryptoContext ) );
    ChkDR( DRM_BBX_Initialize( &oBBContext ) );

	ChkDR( DRM_DCP_GetAttribute( &dstrDevCert, DRM_DEVCERT_GROUPSECURITYLEVEL, NULL, &wszValue) );
	DRMCRT_wcsntol( wszValue.pwszString, wszValue.cchString,(DRM_LONG*)&appSec ) ;
	ChkDR( DRM_DCP_GetAttribute( &dstrDevCert, DRM_DEVCERT_SUBJECTID, NULL, &wszValue) );
	DRMCRT_wcsntol( wszValue.pwszString, wszValue.cchString,(DRM_LONG*)&appcd_subject );

	ChkDR(DRM_BBX_Initialize(&oBBContext));
    	
	if(iOptions!=3) {      /* 3.  dstrContentHeader; */
		DX_VOS_Utf8ToUtf16(wszHeader, sizeof(_wszHeader)*sizeof(DRM_WCHAR), _wszHeader);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentHeader, wszHeader );
	} else if (argv[1]) {
		if(!DX_VOS_StrCmp(argv[1],"DefaultContentHeader")) {
			DX_VOS_Utf8ToUtf16(wszDefaultHeader, sizeof(_wszDefaultHeader)*sizeof(DRM_WCHAR), _wszDefaultHeader);
			ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentHeader, wszDefaultHeader );
		} else if(!DX_VOS_StrCmp(argv[1],"OldContentHeader")) {
			DX_VOS_Utf8ToUtf16(wszOldHeader, sizeof(_wszOldHeader)*sizeof(DRM_WCHAR), _wszOldHeader);
			ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentHeader, wszOldHeader );
		} else if(!DX_VOS_StrCmp(argv[1],"BogusContentHeader")) {
			DX_VOS_Utf8ToUtf16(wszBogusHeader, sizeof(_wszBogusHeader)*sizeof(DRM_WCHAR), _wszBogusHeader);
			ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentHeader, wszBogusHeader );
		}
	}
    
	if(iOptions!=4) {     /* 4.  dstrContentLicense; */
		DX_VOS_Utf8ToUtf16(wszLicense, sizeof(_wszLicense)*sizeof(DRM_WCHAR), _wszLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense, wszLicense );
	} else if (!argv[1])
		Context.dstrContentLicense.pwszString = NULL;
	else if(!DX_VOS_StrCmp(argv[1],"wszOldLicense")) {
		DX_VOS_Utf8ToUtf16(wszOldLicense, sizeof(_wszOldLicense)*sizeof(DRM_WCHAR), _wszOldLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense, wszOldLicense);
	} else if(!DX_VOS_StrCmp(argv[1],"wszInvalidLicense")) {
		DX_VOS_Utf8ToUtf16(wszInvalidLicense, sizeof(_wszInvalidLicense)*sizeof(DRM_WCHAR), _wszInvalidLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense, wszInvalidLicense );
	} else if(!DX_VOS_StrCmp(argv[1],"NOStoreRight")) {
		DX_VOS_Utf8ToUtf16(wszNOStoreRightLicense, sizeof(_wszNOStoreRightLicense)*sizeof(DRM_WCHAR), _wszNOStoreRightLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense,wszNOStoreRightLicense );
	} else if(!DX_VOS_StrCmp(argv[1],"NOSelectRight"))	{
		DX_VOS_Utf8ToUtf16(wszNOSelectRightLicense, sizeof(_wszNOSelectRightLicense)*sizeof(DRM_WCHAR), _wszNOSelectRightLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense,wszNOSelectRightLicense );
	} else if(!DX_VOS_StrCmp(argv[1],"NODeleteRight"))	{
		DX_VOS_Utf8ToUtf16(wszNODeleteRightLicense, sizeof(_wszNODeleteRightLicense)*sizeof(DRM_WCHAR), _wszNODeleteRightLicense);
		ASSIGN_WSTR_TO_DRMSTRING( Context.dstrContentLicense,wszNODeleteRightLicense );
	}
	
	if(iOptions!=13) { /* 13. rgbKID; */
		ChkDR( DRM_HDR_GetAttribute(&(Context.dstrContentHeader), NULL, DRM_HEADER_ATTRIB_KID, &wszKID, 0) );
	} else if (!argv[1])
		wszKID.pwszString = NULL;
	else if(!DX_VOS_StrCmp(argv[1],"InvalidKID")) {
		DX_VOS_Utf8ToUtf16(InvalidrgbKID, sizeof(_InvalidrgbKID)*sizeof(DRM_WCHAR), _InvalidrgbKID);
		ASSIGN_WSTR_TO_DRMSTRING(wszKID, InvalidrgbKID);
	}
	
	if (iOptions != 14) /* fGlobalSecStoreWritable*/
		Context.fGlobalSecStoreWritable = TRUE;

	Context.pcontextHDS = g_pHdsContext;

	ChkDR(DRM_LST_Open(&oLicStoreContext, g_pHdsContext));
	/* Add the license to the store */

    // BUGBUG  This will always fail.  Last 3 params need to be fixed.
	ChkDR(DRM_LST_AddLicense(&oLicStoreContext, Context.dstrContentLicense.cchString * sizeof(DRM_WCHAR), (DRM_BYTE*)Context.dstrContentLicense.pwszString, NULL, NULL, 0));

	ChkDR(DRM_LST_InitEnum(&oLicStoreContext, NULL, FALSE, &oLicStoreEnumContext));
	Context.contextEXPR.pLicStoreEnumContext = &oLicStoreEnumContext;
	ChkDR(DRM_LST_EnumNext(&oLicStoreEnumContext, (DRM_KID*)rgbKID, &lid, NULL, &cbKID)); /* start the enumerator */

	/* If the following base64 decode fails because the buffer isn't big enough then it isn't a valid KID anyway. */
	cbKID = sizeof( rgbKID );
	DX_VOS_MemSet( rgbKID, 0, sizeof( rgbKID ) );
	ChkDR( DRM_B64_DecodeW(&wszKID, &cbKID, rgbKID, 0) );

	/*Talk to blackbox to get the global secure store password */
	if(iOptions!=19) {
		ChkDR(DRM_SST_CreateGlobalStorePassword(szSecStorePassword, (DRM_BYTE*)&oBBContext));
	} else if (!argv[1])
		DX_VOS_MemSet(szSecStorePassword, 0, sizeof( szSecStorePassword ));
	else if(!DX_VOS_StrCmp(argv[1],"InvalidGlobalSecStorePassword"))
		DX_VOS_MemSet(szSecStorePassword, 1, sizeof( szSecStorePassword ));
	
	ChkMem( Context.pcontextSSTGlobal = (DRM_SECSTORE_CONTEXT*) OEM_malloc( sizeof(DRM_SECSTORE_CONTEXT) ) );

	ChkDR( DRM_SST_OpenKeyTokens (
		Context.pcontextSSTGlobal, 
		&g_rgbSecStoreGlobalName, 
		NULL,
		szSecStorePassword, 
		DRM_SECURE_STORE_CREATE_IF_NOT_EXISTS,
		SECURE_STORE_GLOBAL_DATA, 
		g_pHdsContext));
 
	/*add revocation:  revocation store not opened here */
	/* 9. pcontextSSTRevocation */
	if(iOptions!=9) {
		Context.cbRevocationBuffer = 10*1024; //BUGBUG:  MAX_REVOCATION_LIST_SIZE;
		OEM_free(Context.pbRevocationBuffer);
		ChkMem(Context.pbRevocationBuffer = (DRM_BYTE*)OEM_malloc(Context.cbRevocationBuffer));
		DX_VOS_FastMemCpy(&Context.appcert, g_teststubcert, sizeof(APPCERT));

		ChkMem( Context.pcontextSSTRevocation = (DRM_SECSTORE_CONTEXT*) OEM_malloc( sizeof(DRM_SECSTORE_CONTEXT)  ) );
	} else if (!(argv[1]))  /* NULL */
		Context.pcontextSSTRevocation = NULL;

	if(iOptions!=5) {      /* 5. dstrBBVer; */ 
		/* The real current version of drm is 2.3.101.0 */
        MEMCPY( bBBVer, oBBContext.cachedCertValues.m_BBCompatibilityCert.pk.version, VERSION_LEN);
		ChkDR( DRM_UTL_GetVersionAsString( bBBVer, wszBBVerString) ); 
		/*	The legacy compatability version used for license acquisition requests  current for this code is 2.3.0.2
		ChkDR( DRM_BBX_GetLegacyLicenseChallengeVersionString( wszBBVerString, &oBBContext) ); */

		Context.dstrBBVer.pwszString = wszBBVerString;
		Context.dstrBBVer.cchString = (DRM_DWORD)DRM_wcslen(Context.dstrBBVer.pwszString );
	} else if (!argv[1]) {
		Context.dstrBBVer.pwszString = NULL;
		Context.dstrBBVer.cchString =  0;
	} else if(!DX_VOS_StrCmp(argv[1],"invalid")) {
		DX_VOS_Utf8ToUtf16(g_wcszInvalidBB_VERSION_STRING, sizeof(_g_wcszInvalidBB_VERSION_STRING)*sizeof(DRM_WCHAR), _g_wcszInvalidBB_VERSION_STRING);
		ASSIGN_WSTR_TO_DRMSTRING(Context.dstrBBVer, g_wcszInvalidBB_VERSION_STRING);
	}

	if(iOptions!=6) {         /* 6.  dstrDRMVer; */
		Context.dstrDRMVer = g_dstrDRM_VERSION_STRING;
	} else if (!argv[1]) {
		Context.dstrDRMVer.pwszString = NULL;
		Context.dstrDRMVer.cchString = 0;
	} else if (!DX_VOS_StrCmp(argv[1],"invalid")) {
		DX_VOS_Utf8ToUtf16(g_wcszInvalidDRM_VERSION_STRING, sizeof(_g_wcszInvalidDRM_VERSION_STRING)*sizeof(DRM_WCHAR), _g_wcszInvalidDRM_VERSION_STRING);
		ASSIGN_WSTR_TO_DRMSTRING(Context.dstrDRMVer, g_wcszInvalidDRM_VERSION_STRING);
	}

	/* We have a license.  Check the revocation list and app cert */
#if DRM_SUPPORT_APP_REVOCATION
	if(iOptions!=9)     /* 9. pcontextSSTRevocation=NULL would crash */
	{
		ChkDR(DRM_RVK_PerformAppRevocationCheck(&Context, g_pHdsContext));
	}
#endif
	/* Get the LID for the license */
	ChkDR( DRM_LIC_GetAttribute( &(Context.dstrContentLicense), NULL, DRM_LICENSE_ATTRIB_LID, NULL, &wszKID, 0 ) );

	if(iOptions==12)	/* 12. rgbLID; */
	{
		if (!argv[1])
		{
			wszKID.pwszString = NULL;
			wszKID.cchString = 0;
		}
		else if(!DX_VOS_StrCmp(argv[1],"invalid"))
		{	
			DX_VOS_Utf8ToUtf16(InvalidrgbLID, sizeof(_InvalidrgbLID)*sizeof(DRM_WCHAR), _InvalidrgbLID);
			wszKID.pwszString = InvalidrgbLID;
			wszKID.cchString = (DRM_DWORD)DRM_wcslen(InvalidrgbLID );
		}
	}

	ChkDR( DRM_UTL_StringToGuid( &wszKID, (DRM_GUID*) Context.LID.rgb ) );

	if(iOptions!=7) {      /* 7. pcontextSSTLicense */
		ChkMem( Context.pcontextSSTLicense = (DRM_SECSTORE_CONTEXT*) OEM_malloc( sizeof(DRM_SECSTORE_CONTEXT)  ) );
		ChkDR( DRM_SST_OpenKeyTokens (
			Context.pcontextSSTLicense, 
			&(Context.LID),
			NULL,
			szSecStorePassword, 
			DRM_SECURE_STORE_CREATE_IF_NOT_EXISTS,
			SECURE_STORE_LICENSE_DATA, 
			g_pHdsContext));
	}

	Context.certinfoSDK.appSec = appSec;
	Context.certinfoSDK.appcd_subject = appcd_subject;
ErrorExit:
	return dr;    /* DRM_SUCCESS; */
}

DRM_RESULT TestDRMEvaluateExpression(long argc, char **argv)
{
	TOKEN tResult;
	DRM_CONST_STRING MyExpression;

	MyExpression.pwszString = NULL;
	
	ChkArg(argc > 0);

    Context.contextEXPR.GetVariable = GlobalGetVariable;
    Context.contextEXPR.SetVariable = GlobalSetVariable;
    Context.contextEXPR.pvOpaqueData = &Context;

	MakeDRMString(&MyExpression, argv[0]);
    ChkDR(DRM_EXPR_EvaluateExpression( &MyExpression, 
                                 &Context.contextEXPR, 
                                 &tResult ) );

	if (argc > 1 && argv[1]) {
		switch(tResult.TokenType)
		{
		case TOKEN_LONG:
			if (tResult.val.lValue != OEM_atol(argv[1])) {
				Log("Trace", "Returns long value %d, Expecting %d", tResult.val.lValue, OEM_atol(argv[1]));
				dr = DRM_S_FALSE;
			}
	    
			break;
		case TOKEN_STRING:
			if (CompDRMString(&(tResult.val.stringValue), argv[1])) {
				Log("Trace", "Returns string value: %S, Expecting: %s", tResult.val.stringValue, argv[1]);
				dr = DRM_S_FALSE;
			}
	        
			break;
		case TOKEN_DATETIME:
			break;
		default:
			Log("Trace",  "Unexpected variant returned from evaluation!" );
			dr = DRM_S_FALSE;
			break;
		}
	}
ErrorExit:
	DX_VOS_MemFree((void*)MyExpression.pwszString);
	return dr;
}

DRM_RESULT XPV_PreTestCase(long lTCID, char *strTCName)
{
	DRM_RESULT dr;
	DRM_CONST_STRING wszHDSPath;
	
	RemoveDRMFile(RMFILE_STORE);
	DX_VOS_Utf8ToUtf16(devcerttemplate, sizeof(_devcerttemplate)*sizeof(DRM_WCHAR), _devcerttemplate);
	DX_VOS_Utf8ToUtf16(priv, sizeof(_priv)*sizeof(DRM_WCHAR), _priv);
	ChkDR(SetDeviceEnv(devcerttemplate, priv, TRUE));

	tGetDeviceStorePathname(&wszHDSPath);
	ChkDR(OpenHDS(&g_pHdsContext, wszHDSPath.pwszString, FALSE));
ErrorExit:
	return dr;
}

DRM_RESULT XPV_PostTestCase(long lTCID, char *strTCName)
{
	DRM_LST_Close(&oLicStoreContext);
	DRM_SST_CloseKey(Context.pcontextSSTGlobal, g_pHdsContext);
	DRM_SST_CloseKey(Context.pcontextSSTLicense, g_pHdsContext);

	OEM_free(Context.pcontextSSTGlobal);
	OEM_free(Context.pcontextSSTLicense);
	OEM_free(Context.pcontextSSTRevocation );
	DX_VOS_MemSet( &Context, 0, sizeof( DRM_LICEVAL_CONTEXT ) );
	DX_VOS_MemSet( &oBBContext, 0, sizeof( DRM_BB_CONTEXT ) );

	CloseHDS(g_pHdsContext);
	g_pHdsContext = NULL;
	RemoveDRMFile(RMFILE_STORE);

	return DRM_SUCCESS;
}

/*
IMPLEMENT_DEFAULT_WARPTEST

BEGIN_APIMAP(RefTestExprEval_ansi, "ExprEval")
	API_ENTRY(TestLicEvalContextSetting)
	API_ENTRY(TestDRMEvaluateExpression)
END_APIMAP
*/

